TITLE   'Heated Semi-Circular Rod'			   	{ exa142.pde }
SELECT     errlim=3e-4     ngrid=1     spectral_colors   { Student Edition }
VARIABLES   temp		
DEFINITIONS
   Lx=0.1     Ly=0.1     r0=0.05
   k     heat		{ Conductivity and power per unit volume, declared }
   fluxd_x=-k*dx(temp)     fluxd_y=-k*dy(temp)
   fluxd=vector( fluxd_x, fluxd_y)     fluxd_m=magnitude( fluxd)
EQUATIONS
   div( fluxd)=heat
BOUNDARIES
region 'domain'   k=3.5   heat=0					{ Granite }
   start  'outer' (-Lx,-Ly) value(temp)=273
   line to (Lx,-Ly)  to (Lx,Ly)  to (-Lx,Ly)  close
region 'steel'  k=45  heat=1.0e6
   start 'rod' (-r0,0) line to (r0,0) arc to (0,r0)  close
PLOTS
   contour( temp)     surface( temp)     contour( temp) painted on 'steel'
   vector( fluxd) norm      contour( fluxd_m) painted	
   elevation( normal(fluxd)) on 'rod'
   elevation( normal(fluxd)) on 'outer'
      report( pi*r0^2/2* 1e6) as 'Heating power'
END


